var count=0;
let xyz ;
window.addEventListener("load", function(evt) {
    /* scraped info is in evt.detail */
    localStorage.setItem("event_details"+count,JSON.stringify(evt.detail));
    ++count;
}, false);

var wk_dropship_ext = {
    'formData': {},
    'productTrackingUpdated': false,
    'activeTask': { 'product': 0, 'options': 0, 'desc': 0, 'variants': 0 },
    'image_validate': function (image_url) {
        var regx = /_\d{2,3}x\d{2,3}\.jpg_\.webp/g;
        var url = image_url;
        return url.replace(regx, '');
    },
    'import_url': '',
    'host': window.location.host,
    'pathname': window.location.pathname,
    'url': window.location.href,
    'product_details': {},
    'auth_button': "<div class='wk-auth-div' title='Update Authentication Data'>&#x2709;</div>",
    'authModalContent': function (endpoint = '', token = '') {
        var html = '';
        html += "<div class='wk-form-group'><label for='wk_endpoint_url'>Endpoint URL</label><input type='text' id='wk_endpoint_url' name='url' value='" + endpoint + "' placeholder='https://www.example.com' class='wk-form-control'></div><div class='wk-form-group'><label for='wk_endpoint_token'>Token</label><input type='text' id='wk_endpoint_token' name='token' value='" + token + "' placeholder='token' class='wk-form-control'/></div>";
        return html;
    },
    'productModalContent': function () {
        var html = '';
        html += "<form id='wk-modal-form' accept-charset='UTF-8'>";
        // tabs container
        html += "<div class='wk-tabs-container'>";
        //tabs list
        html += "\
        <ul class='wktab-tabs' id='wk-product-tabs'>\
            <li class='active'><a href='#wk-product-basic' data-toggle='tab'>Basic</a></li>\
            <li class=''><a href='#wk-product-details' data-toggle='tab'>Details</a></li>\
            <li class=''><a href='#wk-product-additional' data-toggle='tab'>Additional</a></li>\
        </ul>";
        //tabs content
        html += "<div class='wktab-content' id='wk-product-content'>";
        //tab content basic
        html += "\
        <div id='wk-product-basic' class='wk-tab-pane active'>\
            <div class='wk-form-group'>\
                <label class='wk-cb-container'>Import Meta Data<input type = 'checkbox' name = 'export_metadata' value='1' checked ='checked'><span class='wk-cb-checkmark'></span></label>\
            </div>\
            <div class='wk-form-group' style='display:none;'>\
                <label class='wk-cb-container'>Import Product Options<input type = 'checkbox' name = 'export_options' value='1' checked ='checked'><span class='wk-cb-checkmark'></span></label>\
            </div>\
            <div class='wk-form-group'>\
                <label class='wk-cb-container'>Import Product Images<input type = 'checkbox' name = 'export_images' value='1' checked ='checked'><span class='wk-cb-checkmark'></span></label>\
            </div>\
            <div class='wk-form-group'>\
                <label class='wk-cb-container'>Import Product Specifications<input type = 'checkbox' value='1' name = 'export_specifications' checked ='checked'><span class='wk-cb-checkmark'></span></label>\
            </div>\
            <div class='wk-form-group'>\
                <label class='wk-cb-container'>Import Product Description<input type = 'checkbox' value='1' name = 'export_description' checked ='checked'><span class='wk-cb-checkmark'></span></label>\
            </div>\
            <div class='wk-form-group'>\
                <span class='wk-input-group-title'>Price</span>\
                <label class='wk-cb-container wk-input-group'>Discounted<input type = 'radio' name = 'price_type' checked ='checked' value='discounted'><span class='wk-rd-checkmark'></span></label>\
                <label class='wk-cb-container wk-input-group'>Original<input type = 'radio' name = 'price_type' checked ='checked' value='original'><span class='wk-rd-checkmark'></span></label >\
            </div>\
        </div>";
        //tab content DETAILS
        html += "\
        <div id='wk-product-details' class='wk-tab-pane'>\
            <input type='hidden' name='pid' value='' />\
            <input type='hidden' name='image' value=''/>\
            <input type='hidden' name='url' value=''/>\
            <input type='hidden' name='descUrl' value=''/>\
            <input type='hidden' name='currencyCode' value=''/>\
            <input type='hidden' name='specifications' value=''/>\
            <input type='hidden' name='stock' value=''/>\
            <input type='hidden' name='max_purchase_limit' value=''/>\
            <input type='hidden' name='optiondata' value='' />\
            <div class='wk-form-group'>\
                <label for='wk_wix_ae_pname'>Name</label>\
                <input type='text' id='wk_wix_ae_pname' name='name' value='' class='wk-form-control'/>\
            </div>\
            <div class='wk-form-group wk-input-small'>\
                <label for='wk_wix_ae_pprice'>Price</label>\
                <input type='text' id='wk_wix_ae_pprice' name='price' value='' class='wk-form-control'/><span id='wk-currency-symbol'>%</span><span id='wk-display-price'>\
            </div>\
            <div class='wk-meta-fields'>\
                <div class='wk-form-group '>\
                    <label for='wk_wix_ae_pmetatitle'>Meta Title</label>\
                    <input type='text' id='wk_wix_ae_pmetatitle' name='meta_title' value='' class='wk-form-control'/>\
                </div>\
                <div class='wk-form-group'>\
                    <label for='wk_wix_ae_pmetadesc'>Meta Description</label>\
                    <textarea id='wk_wix_ae_pmetadesc' name='meta_desc' value='' class='wk-form-control' rows='6'></textarea>\
                </div>\
                <div class='wk-form-group'>\
                    <label for='wk_wix_ae_pmetakey'>Meta Tag Keywords</label>\
                    <textarea id='wk_wix_ae_pmetakey' name='meta_key' value='' class='wk-form-control' rows='3'></textarea>\
                </div>\
            </div>\
        </div>";
        //tab content ADDITIONAL
        html += "<div id='wk-product-additional' class='wk-tab-pane'>\
            <div class='wk-product-images-container'><div class='clear'></div></div>\
            <div class='wk-product-options-container'><div class='clear'></div></div>\
        </div>";
        //closing tabs
        html += "</div></div>";
        //close form
        html += "</form>";
        return html;
    },

    'order_items': {},

    'createModal': function (modalId = 'wk-basic-modal') {
        var modalHtml = '';
        //add backdrop 
        modalHtml += '<div class="wk-modal-backdrop wk-fade"></div>';
        modalHtml += '<div id="' + modalId + '" class="wk-modal wk-fade" tabindex="-1" data-keyboard="false" data-backdrop="static" role="dialog"><div class="wk-modal-content">';
        //add header  
        modalHtml += '<div class="wk-modal-header btn-primary"><button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button><h3 class="wk-modal-title" id="' + modalId + '-heading"></h3></div>';
        //add loader 
        modalHtml += '<div class="wk-loader-overlay"><div class="wk-loader cp-spinner cp-skeleton"></div></div>';

        //add body
        modalHtml += '<div class="wk-modal-body" id="' + modalId + '-body"></div >';
        //add footer 
        modalHtml += '<div class="wk-modal-footer"><button type="button" class="btn btn-default" data-dismiss="modal">Close</button>';
        //submit button       
        modalHtml += '<button type="button" class="btn btn-success wk-modal-submit" id=""></button>';

        modalHtml += '</div>';
        modalHtml += '</div></div>';
        return modalHtml;
    },
    'updateModalBody': function (content = '', override = false, clearMsg = true, modalId = '#wk-basic-modal', dir = 'asc') {
        if (override) {
            $(modalId + '-body').html(content);
        } else {
            if (clearMsg) {
                //remove all previous error/msg 
                $(modalId).find(".wk-response-error,.wk-response-msg").remove();
            }
            if (dir == 'desc') {
                $(modalId + '-body').prepend(content);
            } else {
                $(modalId + '-body').append(content);
            }
            $(modalId + '-body').stop().animate({
                scrollTop: $(modalId + '-body div:last').offset().top
            }, 300);
        }
    },
    // 'basicModal': wk_dropship_ext.createModal('wk-basic-modal'), 
    'showModal': function (title = '', body = '', submitText = 'Validate', modalId = '#wk-basic-modal') {
        $(modalId + '-heading').html(title);
        $(modalId + '-body').html(body);
        //configure submit button
        if (submitText === false) {
            $(modalId).find(".wk-modal-submit").hide();
        } else {
            $(modalId).find(".wk-modal-submit").attr('id', 'wk-' + submitText.replace(/[/\s]/gi, '-').toLowerCase()).html(submitText).show();
        }
        $(modalId).prev('.wk-modal-backdrop').addClass('wk-in').show();
        $(modalId).wkmodal("show");
    },
    'hideModal': function (modalId = '#wk-basic-modal') {
        $(modalId).wkmodal("hide");
    },
    'addModalTrigger': function () {
        // auth modal trigger
        $(".wk-auth-div").on("click", function () {

            //check and fill auth data if available  
            var authentication_data = wk_dropship_ext.getAuthData();
            var endpointURL = '';
            var endpointToken = '';
            if (authentication_data.wk_endpoint_url && authentication_data.wk_endpoint_token) {
                endpointURL = authentication_data.wk_endpoint_url;
                endpointToken = authentication_data.wk_endpoint_token;
            }
            wk_dropship_ext.showModal('Authentication', wk_dropship_ext.authModalContent(endpointURL, endpointToken), 'Validate');
        });
        // product import modal trigger 
        $("body").on("click", ".wk-importProductButton,.wk-importProductButtonDetail", function () {
            wk_dropship_ext.showModal('Product Import', wk_dropship_ext.productModalContent(), 'Import');
            wk_dropship_ext.lockModalSubmit();
            wk_dropship_ext.fillProductDetails($(this));
            //bind on change events 
            wk_dropship_ext.bindEvents();
        });

        $('body').on('click', '.wk-address-fill', wk_dropship_ext.fillAddress);
        
    },
    'addModalSubmit': function (modalId = '#wk-basic-modal') {
        $(modalId).on("click", '.wk-modal-submit', function () {
            try {
                var id = $(this).attr('id');
                //disable submit & show loader 
                wk_dropship_ext.lockModalSubmit(modalId);
                switch (id) {
                    case 'wk-validate':
                        request_to_server.validate();
                        break;
                    case 'wk-import':
                        request_to_server.importProduct();
                        break;
                    default:
                        wk_dropship_ext.unlockModalSubmit(modalId);
                }
            } catch (e) {
                var msg = 'Some Error Occured, Please try again';
                if (e.message) {
                    msg = e.message;
                }
                wk_dropship_ext.updateModalBody('<div class="wk-response-error">' + msg + '</div>', false, false);
                wk_dropship_ext.unlockModalSubmit();
            }

        });
    },
    'lockModalSubmit': function (modalId = '#wk-basic-modal') {
        $(modalId).find('.wk-modal-submit').attr('disable', 'disable').addClass('wk-disabled');
        $(modalId).find('.wk-loader-overlay').show();
        //remove all previous error/msg 
        //$(modalId).find(".wk-response-error,.wk-response-msg").remove();
    },
    'unlockModalSubmit': function (modalId = '#wk-basic-modal') {
        $(modalId).find('.wk-modal-submit').removeAttr('disable').removeClass('wk-disabled');
        $(modalId).find('.wk-loader-overlay').hide();
    },
    'appendHtml': function () {
        //add modal 
        $('body').prepend(wk_dropship_ext.createModal());
        //add suth button 
        $('body').prepend(wk_dropship_ext.auth_button);

    },
    'getAuthData': function () {
        var obj = {};
        try {
            obj = {
                wk_endpoint_url: wk_dropship_ext.getStorageItem('wk_endpoint_url'),
                wk_endpoint_token: wk_dropship_ext.getStorageItem('wk_endpoint_token'),
            };
        } catch (e) {
            console.error(e)
        }
        return obj;
    },
    'setStorageItem': function (name, value) {
        try {
            localStorage.setItem(name, value);
        } catch (e) {
            console.error(e.message);
        }
    },
    'getStorageItem': function (name, parse = false) {
        try {
            var data = localStorage.getItem(name);
            if (parse) {
                return JSON.parse(data);
            } else {
                return data;
            }
        } catch (e) {
            console.error(e.message);
        }
    },
    'isSupportedLocalStorage': function isSupported() {
        try {
            const testKey = "_test_key_to_check_storage_";
            localStorage.setItem(testKey, testKey);
            localStorage.removeItem(testKey);
            return true;
        } catch (e) {
            return false;
        }
    },
    'saveAuthData': function (url, token) {
        wk_dropship_ext.setStorageItem('wk_endpoint_url', url);
        wk_dropship_ext.setStorageItem('wk_endpoint_token', token);
    },
    'addImageList': function (addImageHtml) {
        var image_list = {};
        if (addImageHtml.find('[class^="slider--item--"]').length > 0) {
            addImageHtml.find('[class^="slider--item--"]').each(function(index) {
                let sliderImage = "";
                if($(this).find('img').length > 0) {
                    $(this).find('img').each(function() {
                        var regx = /_\d{2,3}x\d{2,3}\.jpg_\.webp/g;
                        sliderImage = $(this).attr('src').replace(regx, '');
                    });
                }
                image_list[index] = sliderImage;
            });  
        }
        return image_list;
    },
    'getProductData': async function (elm = null) {
        if ($.isEmptyObject(wk_dropship_ext.product_details)) {
            //init product variable 
            var product_details = {};
            var zeroDecimalCurrencies = [];
  
            window.runParams =  JSON.parse(localStorage.getItem("event_details0"));
            var ldJsonObject = {};
            const ldJsonScript = $('script[type="application/ld+json"]');
            if (ldJsonScript.length > 0) {
                const ldJsonContent = ldJsonScript.html();
                ldJsonObject = JSON.parse(ldJsonContent);
            }
            //first try to get basic data from JS variable 
            if (window.runParams && !$.isEmptyObject(window.runParams)) {
                if (window.runParams.data) {
                    //on seller store -  data is in seprate modules : 
                    var rdata = window.runParams.data;
                    // if data comes in new order 
                    if(rdata.productInfoComponent) {
                        //basic details 
                        product_details.productId = rdata.productInfoComponent.id;
                        product_details.currencyCode = rdata.currencyComponent.currencyCode;
                        product_details.currencySymbol = wkParser.getCurrencySymbol(rdata.priceComponent.origPrice.maxAmount.formatedAmount);
                        product_details.detailDesc = rdata.productDescComponent.descriptionUrl;
                        //sku module 
                        var option_details = {};
                        if (rdata.skuComponent.productSKUPropertyList) {
                            for (var k in rdata.skuComponent.productSKUPropertyList) {
                                if (rdata.skuComponent.productSKUPropertyList.hasOwnProperty(k)) {
                                    var popt = rdata.skuComponent.productSKUPropertyList[k];
                                    var poptId = popt['skuPropertyId'];
                                    option_details[poptId] = {
                                        "title": popt['skuPropertyName'],
                                        "id": poptId,
                                        'option_values': {}
                                    };
                                    // set option  values
                                    for (var j in popt.skuPropertyValues) {
                                        if (popt.skuPropertyValues.hasOwnProperty(j)) {
                                            var optionId = popt.skuPropertyValues[j]['propertyValueId'];
                                            option_details[poptId]['option_values'][optionId] = {
                                                'id': optionId,
                                                'title': popt.skuPropertyValues[j]['propertyValueDisplayName'],
                                            };
                                            if (popt.skuPropertyValues[j]['skuPropertyImagePath']) {
                                                option_details[poptId]['option_values'][optionId].image_path = popt.skuPropertyValues[j]['skuPropertyImagePath'];
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        product_details.product_variants = option_details;
                        //image module
                        if (typeof rdata.imageComponent.imagePathList[0] != 'undefined') {
                            product_details.additionalImages = rdata.imageComponent.imagePathList;
                            product_details.mainImage = product_details.additionalImages[0];
                        }
                        //price  module 
                        product_details.maxPrice = rdata.priceComponent.origPrice.maxAmount.value;
                        product_details.minPrice = rdata.priceComponent.origPrice.minAmount.value;
                        product_details.discountedMaxPrice = rdata.priceComponent.discountPrice.maxActivityAmount ? rdata.priceComponent.discountPrice.maxActivityAmount.value : '';
                        product_details.discountedMinPrice = rdata.priceComponent.discountPrice.minActivityAmount ? rdata.priceComponent.discountPrice.minActivityAmount.value : '';
                        //quantity module 
                        product_details.totalAvailQuantity = rdata.inventoryComponent.totalAvailQuantity;
                        // product_details.purchaseLimit = rdata.quantityModule.purchaseLimitNumMax;
                        product_details.purchaseLimit = 0;//rdata.quantityModule.purchaseLimitNumMax ? rdata.priceComponent.discountPrice.minActivityAmount.value : '';
                        //product specs :
                        if (rdata.productPropComponent) {
                            product_details.prodSpecs = '<div class="product-specs"><ul class="product-specs-list util-clearfix">';
                            for (var k in rdata.productPropComponent.props) {
                                if (rdata.productPropComponent.props[k].attrName) {
                                    product_details.prodSpecs += '<li class="product-prop line-limit-length">\
                                        <span class="property-title">'+ rdata.productPropComponent.props[k].attrName + '</span>: \
                                        <span class="property-desc line-limit-length">'+ rdata.productPropComponent.props[k].attrValue + '</span>\
                                    </li>';
                                }
                            }
                            product_details.prodSpecs += "</ul></div>";
                        }
                    } else {
                        //basic details 
                        let productGlobalData = rdata.GLOBAL_DATA.globalData;
                        let priceData = rdata.PRICE;
                        let priceLocalConfig = JSON.parse(priceData.priceLocalConfig);
                        product_details.productId = productGlobalData.productId;
                        product_details.currencyCode = productGlobalData.currencyCode;
                        product_details.currencySymbol = priceLocalConfig.single.currencySymbol;
                        product_details.detailDesc = rdata.DESC.pcDescUrl;
                        //sku module 
                        var option_details = {};
                        if (rdata.SKU.skuProperties) {
                            for (var k in rdata.SKU.skuProperties) {
                                if (rdata.SKU.skuProperties.hasOwnProperty(k)) {
                                    var popt = rdata.SKU.skuProperties[k];
                                    var poptId = popt['skuPropertyId'];
                                    option_details[poptId] = {
                                        "title": popt['skuPropertyName'],
                                        "id": poptId,
                                        'option_values': {}
                                    };
                                    // set option  values
                                    for (var j in popt.skuPropertyValues) {
                                        if (popt.skuPropertyValues.hasOwnProperty(j)) {
                                            var optionId = popt.skuPropertyValues[j]['propertyValueIdLong'];
                                            option_details[poptId]['option_values'][optionId] = {
                                                'id': optionId,
                                                'title': popt.skuPropertyValues[j]['propertyValueDisplayName'],
                                            };
                                            if (popt.skuPropertyValues[j]['skuPropertyImagePath']) {
                                                console.log(wkParser.keepFirstExtension(popt.skuPropertyValues[j]['skuPropertyImagePath']))
                                                option_details[poptId]['option_values'][optionId].image_path = wkParser.keepFirstExtension(popt.skuPropertyValues[j]['skuPropertyImagePath']);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        product_details.product_variants = option_details;

                        //image module
                        if (typeof rdata.HEADER_IMAGE_PC.imagePathList[0] != 'undefined') {
                            product_details.additionalImages = rdata.HEADER_IMAGE_PC.imagePathList;
                            product_details.mainImage = product_details.additionalImages[0];
                        }
                        // //price  module 
                        let minMaxPrice = this.extractMinMaxPrice(rdata.PRICE, rdata.SKU);
                        product_details.maxPrice = minMaxPrice.maxPrice;
                        product_details.minPrice = minMaxPrice.minPrice;
                        product_details.discountedMaxPrice = minMaxPrice.discMaxPrice;
                        product_details.discountedMinPrice = minMaxPrice.discMinPrice;
                        //quantity module 
                        product_details.totalAvailQuantity = rdata.QUANTITY_PC.totalAvailableInventory;
                        // product_details.purchaseLimit = rdata.quantityModule.purchaseLimitNumMax;
                        product_details.purchaseLimit = 0;//rdata.quantityModule.purchaseLimitNumMax ? rdata.priceComponent.discountPrice.minActivityAmount.value : '';
                        //product specs :
                        if (rdata.PRODUCT_PROP_PC) {
                            product_details.prodSpecs = '<div class="product-specs"><ul class="product-specs-list util-clearfix">';
                            for (var k in rdata.PRODUCT_PROP_PC.showedProps) {
                                if (rdata.PRODUCT_PROP_PC.showedProps[k].attrName) {
                                    product_details.prodSpecs += '<li class="product-prop line-limit-length">\
                                        <span class="property-title">'+ rdata.PRODUCT_PROP_PC.showedProps[k].attrName + '</span>: \
                                        <span class="property-desc line-limit-length">'+ rdata.PRODUCT_PROP_PC.showedProps[k].attrValue + '</span>\
                                    </li>';
                                }
                            }
                            product_details.prodSpecs += "</ul></div>";
                        }
                    }
                } else {
                    //on aliexpress product detail page 
                    product_details.productId = window.runParams.productId ? window.runParams.productId : '';//PRODUCT ID
                    product_details.currencyRate = window.runParams.currencyRate ? window.runParams.currencyRate : 1;//secondary currency rate
                    product_details.currencyCode = window.runParams.currencyCode ? window.runParams.currencyCode : '';//secondary currency code
                    product_details.currencySymbol = window.runParams.currencySymbol ? window.runParams.currencySymbol : '';//secondary currency symbol
                    product_details.maxPrice = window.runParams.maxPrice ? (window.runParams.maxPrice * product_details.currencyRate) : '';//max price in secondary curr
                    product_details.minPrice = window.runParams.minPrice ? (window.runParams.minPrice * product_details.currencyRate) : '';//min price in secondary curr

                    product_details.discountedMaxPrice = window.runParams.actMaxPrice ? (window.runParams.actMaxPrice * product_details.currencyRate) : product_details.maxPrice;//discounted max price in secondary curr
                    product_details.discountedMinPrice = window.runParams.actMinPrice ? (window.runParams.actMinPrice * product_details.currencyRate) : product_details.minPrice;//discounted min price in secondary curr

                    product_details.mainImage = window.runParams.mainBigPic ? window.runParams.mainBigPic : '';//product main pic
                    product_details.additionalImages = window.runParams.imageBigViewURL ? window.runParams.imageBigViewURL : '';// additional images
                    product_details.descUrl = window.runParams.descUrl ? window.runParams.descUrl : '';// short desc
                    product_details.detailDesc = window.runParams.detailDesc ? window.runParams.detailDesc : '';//detail description
                    // product_details.productURL = window.runParams.imageDetailPageURL ? window.runParams.imageDetailPageURL : '';//detail description
                    product_details.topCategoryId = window.runParams.topCategoryId ? window.runParams.topCategoryId : '';//CATEGORY ID
                    product_details.totalAvailQuantity = window.runParams.totalAvailQuantity ? window.runParams.totalAvailQuantity : '';//total quantity
                    if (window.runParams.quantityLimit) {
                        product_details.purchaseLimit = window.runParams.quantityLimit.availQuantityForCustomer;
                    }
                }

            }
            // get data from DOM if not found in JS var
            if (!product_details.mainImage || product_details.mainImage == '') {
                $('[class^="image-view--previewBox--"]').each(function() {
                    if ($(this).find('[class^="magnifier--image--"]').length > 0) {
                        $(this).find('[class^="magnifier--image--"]').each(function() {
                            product_details.mainImage = $(this).attr('src').replace(/^\/+|\/$/g, '');
                        });  
                    }
                });
            }
            //title not available in JS var 
            if ($('[class^="title--wrap--"]').length > 0) {
                $('[class^="title--wrap--"]').each(function() {
                    if ($(this).find('h1').length > 0) {
                        $(this).find('h1').each(function() {
                            product_details.p_name = $(this).text();
                        });  
                    } 
                });
            } else if ($(".product-title[itemprop='name']").length > 0) {
                product_details.p_name = $(".product-title[itemprop='name']").text();
            } else {
                var ptitle = $('.info').children('h3').children('a.product');
                if (ptitle.length > 0) {
                    product_details.p_name = ptitle.attr('title');
                }
            }   
            let variantDetails = await this.extractVariantPrices();
            this.setStorageItem('pageSkuDetails', JSON.stringify(variantDetails));
            let prices = this.findPrices(variantDetails);
            product_details.discountedMinPrice = wkParser.price(prices.minDiscounted);
            product_details.discountedMaxPrice = wkParser.price(prices.maxDiscounted);
            product_details.maxPrice = wkParser.price(prices.maxOriginal);
            product_details.minPrice = wkParser.price(prices.minOriginal);
            if (!product_details.currencyCode || product_details.currencyCode == '') {
                ldJsonObject.forEach(element => {
                    if(element && element.offers) {
                        product_details.currencyCode = element.offers.priceCurrency;
                        product_details.currencySymbol = wkParser.extractCurrencySymbol(product_details.currencyCode);
                    }
                });
            }
            if (!product_details.productURL || product_details.productURL == '') {
                product_details.productURL = window.location.href.split('?')[0];
                product_details.productId = wkParser.extractProductId(product_details.productURL);
            }
            if (!product_details.productId || product_details.productId == '') {
                product_details.productId = $('#hid-product-id').val();
            }
            if ((!product_details.additionalImages || product_details.additionalImages == '') && $('[class^="slider--wrap--"]').length > 0) {
                $('[class^="slider--wrap--"]').each(function() {
                    product_details.additionalImages = wk_dropship_ext.addImageList($(this));
                });  
            }
            product_details.meta_title = $('title').text();
            product_details.meta_desc = $('meta[name=description]').attr('content');
            product_details.meta_keyword = $('meta[name=keywords]').attr('content');
            //round price
            product_details.maxPrice = (Math.round(product_details.maxPrice * 100) / 100);
            product_details.minPrice = (Math.round(product_details.minPrice * 100) / 100);
            product_details.discountedMaxPrice = (Math.round(product_details.discountedMaxPrice * 100) / 100);
            product_details.discountedMinPrice = (Math.round(product_details.discountedMinPrice * 100) / 100);
            //display min and max price 
            product_details.display_max_price = product_details.minPrice + " - " + product_details.maxPrice;

            product_details.display_min_price = product_details.discountedMinPrice + " - " + product_details.discountedMaxPrice;
            //product specifications 
            if (!product_details.prodSpecs || product_details.prodSpecs == '') {
                product_details.prodSpecs = '';
                if ($('[class^="specification--wrap--"]').length > 0) {
                    product_details.prodSpecs = $('[class^="specification--wrap--"]').prop('outerHTML');
                } else if ($(".product-specs").length > 0) {
                    product_details.prodSpecs = $(".product-specs").html();
                }
            }
            if (!product_details.totalAvailQuantity || product_details.totalAvailQuantity == '') {
                if($('[class^="quantity--info--"]').length > 0 ){
                    $('[class^="quantity--info--"]').each(function() {
                        if ($(this).find('span').length > 0) {
                            $(this).find('span').each(function() {
                                let totalQuantity = 0;
                                variantDetails.forEach(item => {
                                    totalQuantity += item.quantity;
                                })
                                product_details.totalAvailQuantity = totalQuantity;
                            });  
                        } 
                    });
                }
            }
            if (!product_details.purchaseLimit || product_details.purchaseLimit == '') {
                product_details.purchaseLimit = $("#j-sku-limitd-num").text();
            }
            if (!product_details.product_variants) {
                //get product options 
                product_details.product_variants = wk_dropship_ext.getProductOptionDetailsFromDom();
            }
            //set product data   
            wk_dropship_ext.product_details = product_details;
        }
        return wk_dropship_ext.product_details;
    },
    'getProductOptionDetailsFromDom': function () {
        var option_details = {};
        optionsList = {};
        if ($('[class^="sku-item--wrap--"]').length > 0) {
            if($('[class^="sku-item--wrap--"]').find('[class^="sku-item--property--"]').length > 0) {
                $('[class^="sku-item--wrap--"]').find('[class^="sku-item--property--"]').each(function() {
                    var propid = null;
                    // prop id
                    if($(this).find('[class^="sku-item--box--"]').length > 0) {
                        $(this).find('[class^="sku-item--box--"]').each(function() {
                            if($(this).find('[class^="sku-item--skus--"]').length > 0) {
                                $(this).find('[class^="sku-item--skus--"]').each(function() {
                                    propid = $(this).attr("data-sku-row");
                                });
                            }
                        });
                    }
                    // title
                    if($(this).find('[class^="sku-item--title--"]').length > 0) {
                        $(this).find('[class^="sku-item--title--"]').each(function() {
                            option_details[propid] = {
                                "title": $(this).find('span').text().replace(/:([^:]*)$/, ''),
                                "id": propid,
                                'option_values': {}
                            };
                        });
                    }
                    // option values
                    if($(this).find('[class^="sku-item--box--"]').length > 0) {
                        $(this).find('[class^="sku-item--box--"]').each(function() {
                            if($(this).find('[class^="sku-item--"]').length > 0) {
                                $(this).find('[class^="sku-item--"]').each(function() {
                                    var option_id = $(this).attr('data-sku-col');
                                    if(option_id) {
                                        option_id = option_id.split('-').pop();
                                    }
                                    if ($(this).attr('class').split(' ').filter(function(cls) {
                                        return cls.startsWith('sku-item--image--');
                                    }).length > 0) {
                                        option_details[propid]['option_values'][option_id] = {
                                            'title': $(this).find('img').attr('alt'),
                                            'image_path': $(this).find('img').attr('src'),
                                            'id': option_id
                                        };
                                    } else if ($(this).attr('class').split(' ').filter(function(cls) {
                                        return cls.startsWith('sku-item--text--');
                                    }).length > 0) {
                                        option_details[propid]['option_values'][option_id] = {
                                            'title': $(this).attr('title'),
                                            'id': option_id
                                        };
                                    }
                                });
                            }
                        });
                    }
                }); 
            }
        }

        return option_details;
    },
    'fillProductDetails': async function (elm) {
        var product_details = await wk_dropship_ext.getProductData(elm);
        wk_dropship_ext.unlockModalSubmit();
        //set data in form 
        $("#wk-basic-modal input[name = 'name']").val(product_details.p_name);
        $("#wk-basic-modal input[name = 'price']").val(product_details.maxPrice);
        $("#wk-basic-modal input[name = 'pid']").val(product_details.productId);
        $("#wk-basic-modal input[name = 'image']").val(product_details.mainImage);
        $("#wk-basic-modal input[name = 'stock']").val(product_details.totalAvailQuantity);
        $("#wk-basic-modal input[name = 'max_purchase_limit']").val(product_details.purchaseLimit);
        if (!$.isEmptyObject(product_details.product_variants)) { //if not empty options
            $("#wk-basic-modal input[name = 'optiondata']").val(JSON.stringify(product_details.product_variants));
        }
        $("#wk-basic-modal input[name = 'url']").val(product_details.productURL);
        $("#wk-basic-modal input[name = 'meta_title']").val(product_details.meta_title);
        $("#wk-basic-modal textarea[name = 'meta_desc']").val(product_details.meta_desc);
        $("#wk-basic-modal textarea[name = 'meta_key']").val(product_details.meta_keyword);
        $("#wk-basic-modal input[name = 'descUrl']").val(product_details.detailDesc);
        $("#wk-basic-modal input[name = 'currencyCode']").val(product_details.currencyCode);
        $("#wk-basic-modal input[name = 'specifications']").val(product_details.prodSpecs);

        //currency symbol 
        $("#wk-currency-symbol").html(product_details.currencySymbol);
        //display price 
        $("#wk-display-price").html(product_details.display_max_price);
        // create input for additional images 
        var imageListInput = '';
        var optionsInput = '';
        if (product_details.additionalImages && !$.isEmptyObject(product_details.additionalImages)) {
            imageListInput += "Select Product Images To Import<span class='wk-cb-all'><label class='wk-cb-container'><input type = 'checkbox' value='' name='wk_cb_all' checked ='checked'><span class='wk-cb-checkmark'></span></label></span><ul class='wk-product-images-list'>";
            for (var k in product_details.additionalImages) {
                imageListInput += "<li class='wk-product-image'>\
                    <label class='wk-cb-box-container'><input type = 'checkbox' value='"+ product_details.additionalImages[k] + "' name='additional_image[]' checked ='checked'><img class='wkimg' src='" + product_details.additionalImages[k]
                    + "_50x50.jpg'></label>\
                </li>";
            }
            imageListInput += "</ul>";
            $("#wk-basic-modal").find('.wk-product-images-container').html(imageListInput);
        }
        if ($.isEmptyObject(product_details.product_variants)) {
            //no variants -  hide options checkbox
            $("#wk-basic-modal").find('input[name="export_options"]').prop("checked", false).parent('label').hide();
        } else {
            for (var k in product_details.product_variants) {
                optionsInput += "<div class='wk-product-variant'>" + product_details.product_variants[k]['title'];
                if (product_details.product_variants[k] && !$.isEmptyObject(product_details.product_variants[k]['option_values'])) {
                    optionsInput += "<span class='wk-cb-all'><label class='wk-cb-container'><input type = 'checkbox' value='' name='wk_cb_all' checked ='checked'><span class='wk-cb-checkmark'></span></label></span>";
                    optionsInput += "<ul class='wk-product-variant-list'>";
                    for (var j in product_details.product_variants[k]['option_values']) {
                        optionsInput += "<li class='wk-product-option'>\
                            <label class='wk-cb-box-container'><input type = 'checkbox' value='"+ product_details.product_variants[k]['option_values'][j]['title'] + "' name='product_variant[" + k + "][" + j + "]' checked ='checked'>";
                        if (product_details.product_variants[k]['option_values'][j]['image_path']) {
                            optionsInput += "<img title='" + product_details.product_variants[k]['option_values'][j]['title'] + "' class='wkimg' src='" + wk_dropship_ext.image_validate(product_details.product_variants[k]['option_values'][j]['image_path']) + "_50x50.jpg'>";
                        } else {
                            optionsInput += "<span class='wkimg wktextonlybtn'>" + product_details.product_variants[k]['option_values'][j]['title'] + "</span>";
                        }
                        "</label>\
                        </li>";
                    }
                    optionsInput += "</ul>";
                }
                optionsInput += "<div class='clear'></div></div>";
            }
            $("#wk-basic-modal").find('.wk-product-options-container').html(optionsInput);
        }

    },
    'bindEvents': async function () {
        var product_details = await wk_dropship_ext.getProductData();
        $('#wk-basic-modal form').on('change', 'input', function (e) {
            var elName = $(this).attr('name');
            var state = this.checked;
            switch (elName) {
                //checkbox
                case "export_metadata":
                    $('#wk-basic-modal form').find('.wk-meta-fields').toggle(state);
                    break;
                case "export_images":
                    $('#wk-basic-modal form').find('.wk-product-images-container').toggle(state);
                    //check if both images and options are unchecked - hide additional tab 
                    if (!state && !$("input[name='export_options']").is(':checked')) {
                        $('.wktab-tabs a[href="#wk-product-additional"]').hide();
                    } else {
                        $('.wktab-tabs a[href="#wk-product-additional"]').show();
                    }
                    break;
                case "export_options":
                    $('#wk-basic-modal form').find('.wk-product-options-container').toggle(state);
                    //check if both images and options are unchecked - hide additional tab 
                    if (!state && !$("input[name='export_images']").is(':checked')) {
                        $('.wktab-tabs a[href="#wk-product-additional"]').hide();
                    } else {
                        $('.wktab-tabs a[href="#wk-product-additional"]').show();
                    }
                    break;
                //radio 
                case "price_type":
                    var value = $(this).val();
                    if (value == 'original') {
                        //change price and display price 
                        $("#wk-basic-modal input[name='price']").val(product_details.maxPrice);
                        //display price 
                        $("#wk-display-price").html(product_details.display_max_price);
                    } else if (value == 'discounted') {
                        //change price and display price 
                        $("#wk-basic-modal input[name='price']").val(product_details.discountedMaxPrice);
                        //display price 
                        $("#wk-display-price").html(product_details.display_min_price);
                    }
                    break;
                //check/uncheck all
                case "wk_cb_all":
                    if (state) {
                        $(this).closest('.wk-cb-all').nextAll("ul:first").find("input[type='checkbox']").each(function () {
                            this.checked = true;
                        });
                    } else {
                        $(this).closest('.wk-cb-all').nextAll("ul:first").find("input[type='checkbox']").each(function () {
                            this.checked = false;
                        });
                    }
                    break;
            }

        });
    },
    'serializeObject': function (obj) {
        var returnObj = {};
        $.each(obj, function () {
            if (returnObj[this.name]) {
                if (!returnObj[this.name].push) {
                    returnObj[this.name] = [returnObj[this.name]];
                }
                returnObj[this.name].push(this.value || '');
            } else {
                returnObj[this.name] = this.value || '';
            }
        });
        return returnObj;
    },
    'validate_form': function (modalId = '#wk-basic-modal') {
        var valid = true;
        //remove all previous errors 
        $(modalId).find('.wk-vadilation-msg').remove();
        var form = $(modalId).find('form');
        //minimum 1 variant need to be selected 
        var variantlist = $(modalId).find('.wk-product-variant-list');
        if (variantlist.length > 0) {
            $(variantlist).each(function () {
                var selectedCb = $(this).find('input[type="checkbox"]:checked');
                if (selectedCb.length == 0) {
                    valid = false;
                    //add message 
                    $(this).before('<div class="wk-vadilation-msg">Select atleast one variant</div>');
                    $(modalId).find('a[href="#wk-product-additional"]').wktab('show');
                }
            });
        }
        return valid;
    },
    'getUrlParameter': function (sParam, forceUpdate = false) {
        if (!wk_dropship_ext.urlParams || forceUpdate) {

            wk_dropship_ext.urlParams = {};
            var parts = window.location.href.replace(/[?&]+([^=&]+)=([^&]*)/gi, function (m, key, value) {
                wk_dropship_ext.urlParams[key] = value;
            });
        }
        if (typeof wk_dropship_ext.urlParams[sParam] != 'undefined') {
            return wk_dropship_ext.urlParams[sParam];
        }
        return '';
    },
    'nextProductIdFromObject': function (o, id) {
        var keys = Object.keys(o),
            idIndex = keys.indexOf(id),
            nextIndex = idIndex += 1;
        if (nextIndex >= keys.length) {
            //we're at the end, there is no next
            return null;
        }
        var nextKey = keys[nextIndex]
        return nextKey;
    },
    'setNativeValue': function (element, value) {
        try {
            const valueSetter = Object.getOwnPropertyDescriptor(element, 'value').set;
            const prototype = Object.getPrototypeOf(element);
            const prototypeValueSetter = Object.getOwnPropertyDescriptor(prototype, 'value').set;
            if (valueSetter && valueSetter !== prototypeValueSetter) {
                prototypeValueSetter.call(element, value);
            } else {
                valueSetter.call(element, value);
            }
            //dispatch event
            element.dispatchEvent(new Event('input', { bubbles: true }));
        } catch (e) {
            console.log(e);
        }

    },
    'fillAddress': function (element) {
        var shippingAddress = wk_dropship_ext.getShippingData();
        $('.wk-addr-hint').remove();
        if (shippingAddress) {
            if ($("#contactPerson").length > 0 && shippingAddress['first_name']) {
                $("#contactPerson").parent().after("<p class='wk-addr-hint'>" + shippingAddress['first_name'] + ' ' + shippingAddress['last_name']+"</p>");
            }
            if ($("#mobileNo").length > 0 && shippingAddress['phone']) {
                $("#mobileNo").parent().after("<p class='wk-addr-hint'>" +shippingAddress['phone']+"</p>");
            }
            if ($("#address").length>0 && shippingAddress['street_1']) {
                $("#address").parent().after("<p class='wk-addr-hint'>" +shippingAddress['street_1']+"</p>");
            }
            if ($("#address2").length > 0 && shippingAddress['street_2']) {
                $("#address2").parent().after("<p class='wk-addr-hint'>" +shippingAddress['street_2']+"</p>");
            }
            if ($("#city").length > 0 && shippingAddress['city']) {
                var cityCtrState = shippingAddress['city'];
                if ($(".country-name").length > 0 && shippingAddress['country']) {
                    cityCtrState += " / " + shippingAddress['country'];

                    if (shippingAddress['state']) {
                        cityCtrState += ' /' + shippingAddress['state'];
                    }
                    
                    // if ($("span.css-flag.css-" + shippingAddress['country'].toLowerCase()).length > 0) {
                    //     $("span.css-flag.css-" + shippingAddress['country'].toLowerCase()).closest('li').trigger('click');
                    // }

                }    
                $("#city").parent().after("<p class='wk-addr-hint'>" + cityCtrState+"</p>");
            }
            if ($("#zip").length > 0 && shippingAddress['zip']) {
                $("#zip").parent().after("<p class='wk-addr-hint'>" +shippingAddress['zip']+"</p>");
            }
                    
        } else {
            //show error
        }
    },
    'pamReleaseCompatibleUrl' : function(url) {
        // check for platform 
        if (url.indexOf('/wix/app') >= 0) {
            return url;
        }
        // if platform not exists add
        var urlArr = url.split('/app/');
        return urlArr[0]+'/wix/app/'+urlArr[1];
    },
    'extractMinMaxPrice': function (priceData, skuData) {
        let minPrice = Infinity;
        let maxPrice = -Infinity;
        let discMinPrice = Infinity;
        let discMaxPrice = -Infinity;
        let skuPriceList = priceData.skuIdStrPriceInfoMap;
        let skuPaths = skuData.skuPaths;
        let priceRanges = {};
        for (const skuPrice in skuPriceList) {
            let skuIndex = this.findIndexById(skuPaths,skuPrice);
            if(skuIndex ==-1 || !skuPaths[skuIndex].salable) {
                continue;
            }
            if (skuPriceList.hasOwnProperty(skuPrice)) {
                let origPrice = skuPriceList[skuPrice].originalPrice;
                const salePriceLocal = skuPriceList[skuPrice].salePriceLocal;
                const parts = salePriceLocal.split('|');
                const salePrice = parseFloat(parts[1] + '.' + parts[2]);
                // no discount
                if (!origPrice) {
                    origPrice = salePrice;
                    if (origPrice < minPrice) {
                        minPrice = origPrice;
                    }
                    if (origPrice > maxPrice) {
                        maxPrice = origPrice;
                    }
                } else {
                    if (origPrice.value < minPrice) {
                        minPrice = origPrice.value;
                    }
                    if (origPrice.value > maxPrice) {
                        maxPrice = origPrice.value;
                    }
                    if (salePrice < discMinPrice) {
                        discMinPrice = salePrice;
                    }
                    if (salePrice > discMaxPrice) {
                        discMaxPrice = salePrice;
                    }
                }
            }
        }
        priceRanges = {
            'minPrice': minPrice,
            'maxPrice': maxPrice,
            'discMinPrice': discMinPrice == Infinity ? 0 : discMinPrice,
            'discMaxPrice': discMaxPrice == -Infinity ? 0 : discMaxPrice
        }
        return priceRanges;
    },
    'findIndexById': function(array, id) {
        return array.findIndex(obj => obj.skuIdStr === id);
    },
    'extractVariantPrices': async function () {
        var options = [];
        if ($('[class^="sku-item--wrap--"]').length > 0) {
            if($('[class^="sku-item--wrap--"]').find('[class^="sku-item--property--"]').length > 0) {
                $('[class^="sku-item--wrap--"]').find('[class^="sku-item--property--"]').each(function() {
                    var groupTitle = "";
                    var groupOptions = [];
                    if($(this).find('[class^="sku-item--title--"]').length > 0) {
                        $(this).find('[class^="sku-item--title--"]').each(function() {
                            groupTitle =  $(this).find('span').text().replace(/:([^:]*)$/, '');
                        });
                    }
                    if($(this).find('[class^="sku-item--box--"]').length > 0) {
                        $(this).find('[class^="sku-item--box--"]').each(function() {
                            if($(this).find('[class^="sku-item--"]').length > 0) {
                                $(this).find('[class^="sku-item--"]').each(function() {
                                    var optionDetails = {};
                                    let varSkuAttr = $(this).attr('data-sku-col');
                                    if(varSkuAttr) {
                                        optionDetails.skuAttr = varSkuAttr.replace(/-/g, ":");
                                        if ($(this).attr('class').split(' ').filter(function(cls) {
                                            return cls.startsWith('sku-item--image--');
                                        }).length > 0) {
                                            optionDetails.title = $(this).find('img').attr('alt');
                                        } else if ($(this).attr('class').split(' ').filter(function(cls) {
                                            return cls.startsWith('sku-item--text--');
                                        }).length > 0) {
                                            optionDetails.title = $(this).attr('title');
                                        }
                                        groupOptions.push(optionDetails);
                                    }
                                });
                            }
                        });
                    }
                    options.push({
                        title: groupTitle,
                        options: groupOptions
                    });
                }); 
            }
        }
        var combinations = this.generateCombinations(options);
        await this.simulateClicksAndExtractPrices(combinations);
        return combinations;
        
    },
    'generateCombinations': function (options, index = 0, currentCombination = {}, currentSkuAttr = "", combinations = []) {
        if (index === options.length) {
            currentCombination.skuAttr = currentSkuAttr;
            combinations.push(currentCombination);
            return combinations;
        }

        var optionGroup = options[index];
        for (var i = 0; i < optionGroup.options.length; i++) {
            var newCombination = Object.assign({}, currentCombination);
            var newSkuAttr = currentSkuAttr ? currentSkuAttr + ";" + optionGroup.options[i].skuAttr : optionGroup.options[i].skuAttr;
            newCombination[optionGroup.title] = optionGroup.options[i].title;
            combinations = this.generateCombinations(options, index + 1, newCombination, newSkuAttr, combinations);
        }
        return combinations;
    },   
    'simulateClicksAndExtractPrices': async function (combinations) {
        for (var i = 0; i < combinations.length; i++) {
            var combination = combinations[i];
            for (var key in combination) {
                // Simulate click for each option value
                var optionValue = combination[key];
                $('[class^="sku-item--wrap--"]').find('[class^="sku-item--property--"]').each(function() {
                    if ($(this).find('[class^="sku-item--title--"]').length > 0 && $(this).find('span').first().text().replace(/:([^:]*)$/, '') === key) {
                        $(this).find('[class^="sku-item--box--"]').find('[class^="sku-item--"]').each(function() {
                            if ($(this).find('img').attr('alt') === optionValue || $(this).attr('title') === optionValue) {
                                $(this).click();
                            }
                        });
                    }
                });
            }

            await new Promise(resolve => setTimeout(resolve, 10));
            if($('[class^="price--originalText--"]').length > 0) {
                combination.originalPrice = wkParser.extractPrice($('[class^="price--originalText--"]').text()); 
            }
            if($('[class^="price--currentPriceText--"]').length > 0) {
                combination.discountedPrice = wkParser.extractPrice($('[class^="price--currentPriceText--"]').text()); 
            }
            if(!combination.originalPrice) {
                combination.originalPrice = combination.discountedPrice;
            }
            if($('[class*="quantity--info--"] span').length > 0) {
                var textContent = $('[class*="quantity--info--"] span').text();
                var match = textContent.match(/\d+/);
                var inventory = match ? parseInt(match[0], 10) : null;
                combination.quantity = inventory;
            }
        }
        return combinations;
    },
    'findPrices': function(data) {
        const initial = {
            maxOriginal: -Infinity,
            minOriginal: Infinity,
            maxDiscounted: -Infinity,
            minDiscounted: Infinity
        };
    
        const prices = data.reduce((acc, item) => {
            const originalPrice = parseFloat(item.originalPrice);
            const discountedPrice = parseFloat(item.discountedPrice);
    
            return {
                maxOriginal: Math.max(acc.maxOriginal, originalPrice),
                minOriginal: Math.min(acc.minOriginal, originalPrice),
                maxDiscounted: Math.max(acc.maxDiscounted, discountedPrice),
                minDiscounted: Math.min(acc.minDiscounted, discountedPrice)
            };
        }, initial);
    
        return prices;
    }
};


var request_to_server = {
    'validate': function () {
        //update modal body 
        wk_dropship_ext.updateModalBody('<div class="wk-response-msg">Validating Credentials please wait....</div>');
        // get credentials 
        var endpointURL = $('#wk-basic-modal').find("#wk_endpoint_url").val();
        var endpointToken = $('#wk-basic-modal').find("#wk_endpoint_token").val();
        if (endpointURL == undefined || endpointURL.trim() == '' || endpointToken == undefined || endpointToken.trim() == '') {
            wk_dropship_ext.updateModalBody('<div class="wk-response-error">Please check Credentials,<br/>Endpoint URL and Token both are required</div>');
            wk_dropship_ext.unlockModalSubmit();
        } else {
            endpointURL = wk_dropship_ext.pamReleaseCompatibleUrl(endpointURL);
            //send request
            console.log(endpointURL);
            jQuery.support.cors = true;
            $.ajax({
                async: true,
                url: endpointURL + 'validate',
                type: 'GET',
                data: {
                    endpoint_token: endpointToken,
                },
                dataType: 'json',
                success: function (data) {
                    if (data.auth) {
                        wk_dropship_ext.saveAuthData(endpointURL, endpointToken);
                    } else {
                        validation_result = 0;
                    }
                    wk_dropship_ext.updateModalBody('<div class="wk-response-msg wk-msg-success">' + data.msg + '</div>');
                    if (!wk_dropship_ext.isSupportedLocalStorage()) {
                        wk_dropship_ext.updateModalBody('<div class="wk-response-error">Storage is not supported, please check your browser settings</div>', false, false);
                    }
                    wk_dropship_ext.unlockModalSubmit();
                },
                error: function (xhr, ajaxOptions, thrownError) {
                    validation_result = 0;
                    if (!thrownError || thrownError == '') {
                        thrownError = 'Something went wrong, Please try after some time.'
                    }
                    wk_dropship_ext.updateModalBody('<div class="wk-response-error">' + thrownError + '</div>');
                    wk_dropship_ext.unlockModalSubmit();

                }
            });
        }
    },

    'importProduct': function () {
        var auth_data = wk_dropship_ext.getAuthData();
        if (!auth_data.wk_endpoint_url || auth_data.wk_endpoint_url == '' || !auth_data.wk_endpoint_token || auth_data.wk_endpoint_token == '') {
            wk_dropship_ext.updateModalBody('<div class="wk-response-error">Please check Credentials,<br/>Endpoint URL and Token both are required</div>');
            wk_dropship_ext.unlockModalSubmit();
        } else {
            var exportForm = $('#wk-basic-modal').find('form');
            if (exportForm.length == 0) {
                //body is modified : no need to submit 
                wk_dropship_ext.updateModalBody('<div class="wk-response-msg">No data found. Please close the import product popup and try again', true);
                wk_dropship_ext.unlockModalSubmit();
                return false;
            }
            // validate required fields before import product 
            if (!wk_dropship_ext.validate_form()) {
                wk_dropship_ext.unlockModalSubmit();
                return false;
            }
            wk_dropship_ext.formData = wk_dropship_ext.serializeObject(exportForm.serializeArray());
            var product_details = encodeURI(exportForm.serialize());
            wk_dropship_ext.formDataSerialize = product_details;
            var endpointURL = wk_dropship_ext.pamReleaseCompatibleUrl(auth_data.wk_endpoint_url);
            jQuery.support.cors = true;
            $.ajax({
                async: true,
                url: endpointURL + 'product/import',
                type: 'POST',
                data: {
                    endpoint_token: auth_data.wk_endpoint_token,
                    product_data: product_details
                },
                dataType: 'json',
                beforeSend: function (e) {
                    wk_dropship_ext.updateModalBody('<div class="wk-response-msg">Product import in progress please wait....</div>', true);
                    //hide import button
                    $('#wk-basic-modal').find(".wk-modal-submit").hide();
                    wk_dropship_ext.activeTask.product = 1;
                },
                success: function (data) {
                    if (data.auth) {
                        //product import success 
                        wk_dropship_ext.updateModalBody('<div class="wk-response-msg wk-msg-success">' + data.msg + '</div>', false, false);
                    } else {
                        //product import success 
                        wk_dropship_ext.updateModalBody('<div class="wk-response-msg wk-msg-error">' + data.msg + '</div>', false, false);
                        validation_result = 0;
                    }
                },
                error: function (xhr, ajaxOptions, thrownError) {
                    wk_dropship_ext.updateModalBody('<div class="wk-response-msg">' + thrownError + '</div>', false, false);
                    validation_result = 0;
                },
                complete: function (e) {
                    wk_dropship_ext.activeTask.product = 0;
                    if (!wk_dropship_ext.activeTask.product && !wk_dropship_ext.activeTask.options && !wk_dropship_ext.activeTask.desc && !wk_dropship_ext.activeTask.variants) {
                        wk_dropship_ext.unlockModalSubmit();
                    }
                }
            });
        }
    },
}

var app_event = {
    'product_import': function () {
        $(".import-button").on("click", function () {
            $("#product_data_modal").hide();
            request_to_server.importProduct();
        });
    },
}

/**
 *  Issues : only consider 2 decimal places 
 *  If no thousand seprator and having 3 decimal places : 2.123 will return 2123 - wrong 
 *  Example : wkParser.price('1,234.56') -> 1234.56 //working fine if both thousand and decimal
 *            wkParser.price('1,234')    -> 1234
 *            wkParser.price('1.234')    -> 1234
 *            wkParser.price('1,23')     -> 1.23
 *            wkParser.price('1.23')     -> 1.23
 */
var wkParser = {
    // only digit : and ; 
    'onlyDCS': function (str) {
        return str.replace(/[^\d:;]/g, '').replace(/[:;]$/, '');
    },
    // replace everything except digits
    'onlyDigits': function (str) {
        return str.replace(/[^\d]/g, '');
    },
    // replace every things except digit , comma AND decimaL
    'onlyDCD': function (str) {
        return str
            .replace(/[^\d.,]/g, '')
            .replace(/[.,]$/, '');
    },
    //only return special character in str except filtered
    'getCurrencySymbol': function (str) {
        return str.replace(/[\d.,~!@#$%грн^&*()_|+\-=?;:'",<>\{\}\[\]\\\/\s]/gi, '');
    },
    // return decimal symbol(, or .) : limitation only consider upto 2 decimal place if no thousand symbol
    'getDecimalSymbol': function (str) {
        var strFiltered = wkParser.onlyDCD(str);
        //if both , and . exists last occurence is decimal symbol 
        var commaIndex = strFiltered.lastIndexOf(',');
        var decimalIndex = strFiltered.lastIndexOf('.');

        if (commaIndex !== -1 && decimalIndex !== -1) {
            //both symbol exists convert to two decimal place
            if (commaIndex > decimalIndex) {
                return ',';
            } else {
                return '.';
            }
        }
        //if only one symbol exists iterate through characters 
        // For each character starting from the end...
        for (var i = strFiltered.length; i > 0; i--) {
            // If the last character is a "0" and the decimal position > 3, no decimal
            if (((strFiltered.length - i + 1) > 3)) {
                return;
            }
            var currentChar = strFiltered[i - 1];
            if ([',', '.'].indexOf(currentChar) !== -1) {
                return currentChar;
            }
        }
    },
    'price': function (input, decimalSeprator = null) {
        var str = String(input);

        //if multiple price in string : seprator - 
        // var tempStr = str.split('-');
        // if (typeof tempStr[pindex] != undefined) {
        //     str = tempStr[pindex];
        // } else {
        //     str = tempStr[0];
        // }
        var decimalPart = '00';
        var decimalSymbol = decimalSeprator ? decimalSeprator : wkParser.getDecimalSymbol(str);
        var formattedPriceArr = str.split(decimalSymbol);
        var integerPart = '0';
        if (formattedPriceArr.length > 2) {
            decimalPart = formattedPriceArr[formattedPriceArr.length - 1];
            integerPart = formattedPriceArr[formattedPriceArr.length - 2];
        } else {
            if (typeof formattedPriceArr[1] != 'undefined') {
                integerPart = formattedPriceArr[1];
            }
            integerPart = formattedPriceArr[0];
        }

        return Number(wkParser.onlyDigits(integerPart) + '.' + wkParser.onlyDigits(decimalPart));
    },
    'extractPrice': function (priceString) {
        let priceMatch = priceString.match(/(\d[\d,]*\.\d{2})\s?[^\d\s,]?|[^\d\s,]?\s?(\d[\d,]*\.\d{2})/);
        let prices = priceMatch;
        if (priceMatch) {
            prices = priceMatch[0].match(/\d[\d,]*\.\d{2}/)[0].replace(/,/g, '');
        }
        return prices;
    },
    'keepFirstExtension': function (url) {
        // Find the position of the first dot after the last slash
        let lastSlashIndex = url.lastIndexOf('/');
        let firstDotAfterSlash = url.indexOf('.', lastSlashIndex);

        // If there is no dot after the last slash, return the original URL
        if (firstDotAfterSlash === -1) {
            return url;
        }

        // Keep the URL up to the first extension
        let baseUrl = url.substring(0, firstDotAfterSlash);
        
        // Find the position where the first extension ends
        let remainingUrl = url.substring(firstDotAfterSlash);

        // Remove any additional extensions in the remaining part
        const pattern = /^(.*?\.(?:jpg|png|gif|webp))_[^_]+$/;
        const match = remainingUrl.match(pattern);
        if (match) {
            remainingUrl = match[1];
        } else {
            remainingUrl = "";
        }

        // Combine the base URL with the cleaned remaining part
        return baseUrl + remainingUrl;
    },
    'extractProductId': function (url) {
        var parts = url.split("/");
        var productId = null;

        for (var i = 0; i < parts.length; i++) {
            if (parts[i].match(/^\d+\.html$/)) {
                productId = parts[i].replace(".html", "");
                break;
            }
        }
        return productId;
    },
    'extractCurrencySymbol': function (currencyCode) {
        return this.currencySymbols[currencyCode] || null;
    },
    'currencySymbols': {
        'AED': 'د.إ', // United Arab Emirates Dirham
        'AFN': '؋', // Afghan Afghani
        'ALL': 'L', // Albanian Lek
        'AMD': '֏', // Armenian Dram
        'ANG': 'ƒ', // Netherlands Antillean Guilder
        'AOA': 'Kz', // Angolan Kwanza
        'ARS': '$', // Argentine Peso
        'AUD': 'A$', // Australian Dollar
        'AWG': 'ƒ', // Aruban Florin
        'AZN': '₼', // Azerbaijani Manat
        'BAM': 'KM', // Bosnia and Herzegovina Convertible Mark
        'BBD': 'Bds$', // Barbadian Dollar
        'BDT': '৳', // Bangladeshi Taka
        'BGN': 'лв', // Bulgarian Lev
        'BHD': '.د.ب', // Bahraini Dinar
        'BIF': 'Fr', // Burundian Franc
        'BMD': '$', // Bermudian Dollar
        'BND': 'B$', // Brunei Dollar
        'BOB': '$b', // Bolivian Boliviano
        'BRL': 'R$', // Brazilian Real
        'BSD': '$', // Bahamian Dollar
        'BTN': 'Nu.', // Bhutanese Ngultrum
        'BWP': 'P', // Botswanan Pula
        'BYN': 'Br', // Belarusian Ruble
        'BZD': 'BZ$', // Belize Dollar
        'CAD': 'CA$', // Canadian Dollar
        'CDF': 'Fr', // Congolese Franc
        'CHF': 'CHF', // Swiss Franc
        'CLP': '$', // Chilean Peso
        'CNY': '¥', // Chinese Yuan
        'COP': '$', // Colombian Peso
        'CRC': '₡', // Costa Rican Colón
        'CUP': '$', // Cuban Peso
        'CVE': '$', // Cape Verdean Escudo
        'CZK': 'Kč', // Czech Koruna
        'DJF': 'Fdj', // Djiboutian Franc
        'DKK': 'kr', // Danish Krone
        'DOP': '$', // Dominican Peso
        'DZD': 'د.ج', // Algerian Dinar
        'EGP': '£', // Egyptian Pound
        'ERN': 'Nfk', // Eritrean Nakfa
        'ETB': 'Br', // Ethiopian Birr
        'EUR': '€', // Euro
        'FJD': 'FJ$', // Fijian Dollar
        'FKP': '£', // Falkland Islands Pound
        'FOK': 'kr', // Faroese Króna
        'GAD': 'G$', // Gambian Dalasi
        'GEL': '₾', // Georgian Lari
        'GHS': '₵', // Ghanaian Cedi
        'GIP': '£', // Gibraltar Pound
        'GMD': 'D', // Gambian Dalasi
        'GNF': 'Fr', // Guinean Franc
        'GTQ': 'Q', // Guatemalan Quetzal
        'GYD': 'GY$', // Guyanaese Dollar
        'HKD': 'HK$', // Hong Kong Dollar
        'HNL': 'L', // Honduran Lempira
        'HRK': 'kn', // Croatian Kuna
        'HTG': 'G', // Haitian Gourde
        'HUF': 'Ft', // Hungarian Forint
        'IDR': 'Rp', // Indonesian Rupiah
        'ILS': '₪', // Israeli New Shekel
        'IMP': '£', // Isle of Man Pound
        'INR': '₹', // Indian Rupee
        'IQD': 'ع.د', // Iraqi Dinar
        'IRR': '﷼', // Iranian Rial
        'ISK': 'kr', // Icelandic Króna
        'JMD': 'J$', // Jamaican Dollar
        'JOD': 'د.ا', // Jordanian Dinar
        'JPY': '¥', // Japanese Yen
        'KES': 'KSh', // Kenyan Shilling
        'KGS': 'сом', // Kyrgystani Som
        'KHR': '៛', // Cambodian Riel
        'KID': 'AU$', // Kiribati Dollar
        'KMF': 'Fr', // Comorian Franc
        'KRW': '₩', // South Korean Won
        'KWD': 'د.ك', // Kuwaiti Dinar
        'KYD': 'KY$', // Cayman Islands Dollar
        'KZT': '₸', // Kazakhstani Tenge
        'LAK': '₭', // Laotian Kip
        'LBP': 'ل.ل', // Lebanese Pound
        'LKR': 'Rs', // Sri Lankan Rupee
        'LRD': '$', // Liberian Dollar
        'LYD': 'ل.د', // Libyan Dinar
        'MAD': 'د.م.', // Moroccan Dirham
        'MDL': 'L', // Moldovan Leu
        'MGA': 'Ar', // Malagasy Ariary
        'MKD': 'ден', // Macedonian Denar
        'MMK': 'K', // Myanma Kyat
        'MNT': '₮', // Mongolian Tugrik
        'MOP': 'MOP$', // Macanese Pataca
        'MRU': 'UM', // Mauritanian Ouguiya
        'MUR': '₨', // Mauritian Rupee
        'MVR': 'Rf', // Maldivian Rufiyaa
        'MWK': 'MK', // Malawian Kwacha
        'MXN': '$', // Mexican Peso
        'MYR': 'RM', // Malaysian Ringgit
        'MZN': 'MT', // Mozambican Metical
        'NAD': '$', // Namibian Dollar
        'NGN': '₦', // Nigerian Naira
        'NIO': 'C$', // Nicaraguan Córdoba
        'NOK': 'kr', // Norwegian Krone
        'NPR': 'Rs', // Nepalese Rupee
        'NZD': 'NZ$', // New Zealand Dollar
        'OMR': 'ر.ع.', // Omani Rial
        'PAB': 'B/.', // Panamanian Balboa
        'PEN': 'S/', // Peruvian Sol
        'PGK': 'K', // Papua New Guinean Kina
        'PHP': '₱', // Philippine Peso
        'PKR': 'Rs', // Pakistani Rupee
        'PLN': 'zł', // Polish Zloty
        'PYG': '₲', // Paraguayan Guarani
        'QAR': 'ر.ق', // Qatari Rial
        'RON': 'lei', // Romanian Leu
        'RSD': 'дин.', // Serbian Dinar
        'RUB': '₽', // Russian Ruble
        'RWF': 'Fr', // Rwandan Franc
        'SAR': 'ر.س', // Saudi Riyal
        'SBD': '$', // Solomon Islands Dollar
        'SCR': '₨', // Seychellois Rupee
        'SDG': 'ج.س.', // Sudanese Pound
        'SEK': 'kr', // Swedish Krona
        'SGD': 'S$', // Singapore Dollar
        'SHP': '£', // Saint Helena Pound
        'SLL': 'Le', // Sierra Leonean Leone
        'SOS': 'Sh', // Somali Shilling
        'SRD': '$', // Surinamese Dollar
        'SSP': '£', // South Sudanese Pound
        'STN': 'Db', // São Tomé and Príncipe Dobra
        'SYP': '£', // Syrian Pound
        'SZL': 'E', // Swazi Lilangeni
        'THB': '฿', // Thai Baht
        'TJS': 'SM', // Tajikistani Somoni
        'TMT': 'm', // Turkmenistani Manat
        'TND': 'د.ت', // Tunisian Dinar
        'TOP': 'T$', // Tongan Paʻanga
        'TRY': '₺', // Turkish Lira
        'TTD': 'TT$', // Trinidad and Tobago Dollar
        'TVD': 'AU$', // Tuvaluan Dollar
        'TZS': 'Sh', // Tanzanian Shilling
        'UAH': '₴', // Ukrainian Hryvnia
        'UGX': 'USh', // Ugandan Shilling
        'USD': '$', // United States Dollar
        'UYU': '$U', // Uruguayan Peso
        'UZS': 'soʻm', // Uzbekistani Som
        'VES': 'Bs', // Venezuelan Bolívar Soberano
        'VND': '₫', // Vietnamese Dong
        'VUV': 'VT', // Vanuatu Vatu
        'WST': 'WS$', // Samoan Tala
        'XAF': 'Fr', // Central African CFA Franc
        'XAG': 'XAG', // Silver Ounce
        'XAU': 'XAU', // Gold Ounce
        'XCD': '$', // East Caribbean Dollar
        'XDR': 'XDR', // International Monetary Fund (IMF) Special Drawing Rights
        'XOF': 'Fr', // West African CFA Franc
        'XPF': 'Fr', // CFP Franc
        'YER': 'ر.ي', // Yemeni Rial
        'ZAR': 'R', // South African Rand
        'ZMK': 'ZK', // Zambian Kwacha (pre-2013)
        'ZWL': 'Z$', // Zimbabwean Dollar
    }
}


var wkInitCount = 0;
//check if jquery loaded
var wkInitInterval = window.setInterval(function () {
    if (typeof $ != 'undefined') {
        clearInterval(wkInitInterval);
        $(document).ready(function () {
            // console.log("rohit",$(".wk-detail-wiximport").length);
            if($(".wk-detail-wiximport").length == 0) {
                $(".pdp-body-top-right").prepend("<div class='wk-detail-wiximport' style='margin-left: 24px;'><img src='" + iconImg + "' title='Import' class='wk-importProductButtonDetail'></div>");                
            }
            var window_url = wk_dropship_ext.url;
            var reg_url = new RegExp('aliexpress'/* "/(https?:\/\/)*[a-z0-9_.]*aliexpress.com[\/]*.*" */);
            
            //add required js 
            if (reg_url.test(window_url)) {
                wk_dropship_ext.appendHtml();
                wk_dropship_ext.addModalTrigger();
                wk_dropship_ext.addModalSubmit();
                app_event.product_import();

                // modal js : loaded here as it 
                !function (t) { var e = function (e, o) { this.options = o, this.$element = t(e).delegate('[data-dismiss="modal"]', "click.dismiss.wk-modal", t.proxy(this.hide, this)), this.options.remote && this.$element.find(".wk-modal-body").load(this.options.remote) }; e.prototype = { constructor: e, toggle: function () { return this[this.isShown ? "hide" : "show"]() }, show: function () { var e = this, o = t.Event("show"); this.$element.trigger(o), this.isShown || o.isDefaultPrevented() || (this.isShown = !0, this.escape(), this.backdrop(function () { var o = t.support.transition && e.$element.hasClass("wk-fade"); e.$element.parent().length || e.$element.appendTo(document.body), e.$element.show(), o && e.$element[0].offsetWidth, e.$element.addClass("wk-in").attr("aria-hidden", !1), e.enforceFocus(), o ? e.$element.one(t.support.transition.end, function () { e.$element.focus().trigger("shown") }) : e.$element.focus().trigger("shown") })) }, hide: function (e) { e && e.preventDefault(), e = t.Event("hide"), this.$element.trigger(e), this.isShown && !e.isDefaultPrevented() && (this.isShown = !1, this.escape(), t(document).off("focusin.wk-modal"), this.$element.removeClass("wk-in").attr("aria-hidden", !0), t.support.transition && this.$element.hasClass("wk-fade") ? this.hideWithTransition() : this.hideModal()), t(".wk-modal-backdrop").removeClass("wk-in").hide() }, enforceFocus: function () { var e = this; t(document).on("focusin.wk-modal", function (t) { e.$element[0] === t.target || e.$element.has(t.target).length || e.$element.focus() }) }, escape: function () { var t = this; this.isShown && this.options.keyboard ? this.$element.on("keyup.dismiss.wk-modal", function (e) { 27 == e.which && t.hide() }) : this.isShown || this.$element.off("keyup.dismiss.wk-modal") }, hideWithTransition: function () { var e = this, o = setTimeout(function () { e.$element.off(t.support.transition.end), e.hideModal() }, 500); this.$element.one(t.support.transition.end, function () { clearTimeout(o), e.hideModal() }) }, hideModal: function () { var t = this; this.$element.hide(), this.backdrop(function () { t.removeBackdrop(), t.$element.trigger("hidden") }) }, removeBackdrop: function () { this.$backdrop && this.$backdrop.remove(), this.$backdrop = null }, backdrop: function (e) { var o = this.$element.hasClass("wk-fade") ? "wk-fade" : ""; if (this.isShown && this.options.backdrop) { var i = t.support.transition && o; if (this.$backdrop = t('<div class="modal-backdrop ' + o + '" />').appendTo(document.body), this.$backdrop.click("static" == this.options.backdrop ? t.proxy(this.$element[0].focus, this.$element[0]) : t.proxy(this.hide, this)), i && this.$backdrop[0].offsetWidth, this.$backdrop.addClass("wk-in"), !e) return; i ? this.$backdrop.one(t.support.transition.end, e) : e() } else !this.isShown && this.$backdrop ? (this.$backdrop.removeClass("wk-in"), t.support.transition && this.$element.hasClass("wk-fade") ? this.$backdrop.one(t.support.transition.end, e) : e()) : e && e() } }; var o = t.fn.wkmodal; t.fn.wkmodal = function (o) { return this.each(function () { var i = t(this), n = i.data("modal"), s = t.extend({}, t.fn.wkmodal.defaults, i.data(), "object" == typeof o && o); n || i.data("modal", n = new e(this, s)), "string" == typeof o ? n[o]() : s.show && n.show() }) }, t.fn.wkmodal.defaults = { backdrop: !0, keyboard: !0, show: !0 }, t.fn.wkmodal.Constructor = e, t.fn.wkmodal.noConflict = function () { return t.fn.wkmodal = o, this }, t(document).on("click.wkmodal.data-api", '[data-toggle="modal"]', function (e) { var o, i, n = t(this), s = n.attr("href"), a = n.attr("data-target"); e.preventDefault(), a || (a = "#" === (a = (a = s) && a.replace(/.*(?=#[^\s]+$)/, "")) ? "" : a), i = (o = t(document).find(a)).data("modal") ? "toggle" : t.extend({ remote: !/#/.test(s) && s }, o.data(), n.data()), o.wkmodal(i).one("hide", function () { n.focus() }) }) }(window.jQuery);
                // tabs js 
                !function (t) { "use strict"; var a = function (a) { this.element = t(a) }; a.prototype = { constructor: a, show: function () { var a, e, n, i = this.element, s = i.closest("ul:not(.dropdown-menu)"), o = i.attr("data-target"); o || (o = (o = i.attr("href")) && o.replace(/.*(?=#[^\s]*$)/, "")), i.parent("li").hasClass("active") || (a = s.find(".active:last a")[0], n = t.Event("show", { relatedTarget: a }), i.trigger(n), n.isDefaultPrevented() || (e = t(o), this.activate(i.parent("li"), s), this.activate(e, e.parent(), function () { i.trigger({ type: "shown", relatedTarget: a }) }))) }, activate: function (a, e, n) { function i() { s.removeClass("active").find("> .dropdown-menu > .active").removeClass("active"), a.addClass("active"), o ? (a[0].offsetWidth, a.addClass("in")) : a.removeClass("fade"), a.parent(".dropdown-menu") && a.closest("li.dropdown").addClass("active"), n && n() } var s = e.find("> .active"), o = n && t.support.transition && s.hasClass("wk-fade"); o ? s.one(t.support.transition.end, i) : i(), s.removeClass("wk-in") } }; var e = t.fn.wktab; t.fn.wktab = function (e) { return this.each(function () { var n = t(this), i = n.data("tab"); i || n.data("tab", i = new a(this)), "string" == typeof e && i[e]() }) }, t.fn.wktab.Constructor = a, t.fn.wktab.noConflict = function () { return t.fn.wktab = e, this }, t(document).on("click.wktab.data-api", '[data-toggle="tab"], [data-toggle="pill"]', function (a) { a.preventDefault(), t(this).wktab("show") }) }(window.jQuery);
            }

        });
    } else if (wkInitCount > 5) {
        clearInterval(wkInitInterval);
    }
    ++wkInitCount;
}, 1000);